/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiComponent
extends Screen {
    private GuiComponent parent = null;
    private final List<GuiComponent> children = new CopyOnWriteArrayList<GuiComponent>();
    int properWidth;
    int properHeight;
    int contentWidth;
    int contentHeight;
    private boolean sizeIsInvalid = false;
    private boolean isClipped = false;
    protected boolean isMouseOver = false;
    private boolean interceptsMouse = true;
    private boolean interceptsKeyboard = true;
    private boolean blocksScreen = false;
    private int guiX = 0;
    private int guiY = 0;
    private final HoveringTextInfo hoveringTextInfo = new HoveringTextInfo();

    public GuiComponent() {
        super((Component)Component.m_237113_((String)"component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (GuiComponent child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.invalidateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    protected final void setCentered() {
        this.validateSize();
        if (this.parent == null) {
            this.setGuiCoords((this.f_96543_ - this.getWidth()) / 2, (this.f_96544_ - this.getHeight()) / 2);
        } else {
            this.setRelativeCoords((this.parent.getWidth() - this.getWidth()) / 2, (this.parent.getHeight() - this.getHeight()) / 2);
        }
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.invalidateSize();
    }

    protected GuiComponent addChild(GuiComponent child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public GuiComponent addChildInfrontOf(GuiComponent inFrontOf, GuiComponent child) {
        this.doAddChild(inFrontOf, child, null);
        return child;
    }

    protected GuiComponent addChildBehind(GuiComponent behind, GuiComponent child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    private void doAddChild(GuiComponent inFrontOf, GuiComponent child, GuiComponent behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (Minecraft.m_91087_() != null) {
            child.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        this.invalidateSize();
    }

    protected GuiComponent removeChild(GuiComponent child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.invalidateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    void removeAllChildren() {
        this.children.clear();
        this.invalidateSize();
    }

    public GuiComponent getParent() {
        return this.parent;
    }

    List<GuiComponent> getChildren() {
        return this.children;
    }

    public void setInterceptMouse(boolean value) {
        this.interceptsMouse = value;
    }

    protected void setInterceptKeyboard(boolean value) {
        this.interceptsKeyboard = value;
    }

    protected void setBlocksScreen(boolean value) {
        this.blocksScreen = value;
    }

    boolean iterateInput(UiCall callMethod) {
        ListIterator<GuiComponent> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            GuiComponent child = iter.previous();
            if (!callMethod.call(child)) continue;
            return true;
        }
        return false;
    }

    boolean iterateMouseInput(UiCall callMethod) {
        this.isMouseOver = this.isMouseInRegion(this.getGuiX(), this.getGuiY(), this.getWidth(), this.getHeight());
        if (!this.iterateInput(c -> {
            c.isMouseOver = c.isMouseInRegion(c.getGuiX(), c.getGuiY(), c.getWidth(), c.getHeight());
            return callMethod.call(c);
        })) {
            return false;
        }
        this.isMouseOver = false;
        return true;
    }

    public boolean m_6375_(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.m_6375_(mx, my, mb))) {
            return super.m_6375_(mx, my, mb);
        }
        return true;
    }

    public boolean m_6348_(double mx, double my, int mb) {
        if (!this.iterateMouseInput(c -> c.m_6348_(mx, my, mb))) {
            return super.m_6348_(mx, my, mb);
        }
        return true;
    }

    public boolean m_7979_(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateMouseInput(c -> c.m_7979_(mx, my, mb, mx2, my2))) {
            return super.m_6375_(mx, my, mb);
        }
        return true;
    }

    public boolean m_6050_(double mx, double my, double dy) {
        if (!this.iterateMouseInput(c -> c.m_6050_(mx, my, dy))) {
            return super.m_6050_(mx, my, dy);
        }
        return true;
    }

    public void m_94757_(double mx, double my) {
        if (!this.iterateMouseInput(c -> {
            c.m_94757_(mx, my);
            return false;
        })) {
            super.m_94757_(mx, my);
        }
    }

    public boolean m_7933_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.m_7933_(a, b, c))) {
            return super.m_7933_(a, b, c);
        }
        return true;
    }

    public boolean m_5534_(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.m_5534_(aa, bb))) {
            return super.m_5534_(aa, bb);
        }
        return true;
    }

    public boolean m_7920_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.m_7920_(a, b, c))) {
            return super.m_7920_(a, b, c);
        }
        return true;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(matrices, mouseX, mouseY, partialTick);
        for (GuiComponent child : this.children) {
            if (child.isClipped) continue;
            child.m_6305_(matrices, mouseX, mouseY, partialTick);
        }
        if (this.hoveringTextInfo.shouldDraw) {
            this.drawHoveringText2(matrices, this.hoveringTextInfo.lines, this.hoveringTextInfo.x, this.hoveringTextInfo.y, this.hoveringTextInfo.font);
            this.hoveringTextInfo.shouldDraw = false;
        }
    }

    public void m_7379_() {
        for (GuiComponent child : this.children) {
            child.m_7379_();
        }
        super.m_7379_();
    }

    public void m_86600_() {
        for (GuiComponent child : this.children) {
            child.m_86600_();
        }
        super.m_86600_();
        if (this.sizeIsInvalid) {
            this.validateSize();
        }
    }

    public void m_7856_() {
        super.m_7856_();
        for (GuiComponent child : this.children) {
            child.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    protected int getWidth() {
        return this.contentWidth;
    }

    protected int getHeight() {
        return this.contentHeight;
    }

    void setClipped(boolean value) {
        this.isClipped = value;
    }

    private void invalidateSize() {
        this.sizeIsInvalid = true;
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    void validateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (GuiComponent child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        this.sizeIsInvalid = false;
    }

    boolean isMouseInRegion(int left, int top, int width, int height) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)left && mouseX < (double)(left + width) && mouseY >= (double)top && mouseY < (double)(top + height);
    }

    protected boolean isMouseInRadius(int x, int y, int radius) {
        double mouseX = this.getMouseX();
        double mouseY = this.getMouseY();
        return mouseX >= (double)(x - radius) && mouseX < (double)(x + radius) && mouseY >= (double)(y - radius) && mouseY < (double)(y + radius);
    }

    private void drawHoveringText2(PoseStack matrices, List<Component> lines, double x, double y, Font font) {
        boolean stencilEnabled = GL11.glIsEnabled((int)2960);
        if (stencilEnabled) {
            GL11.glDisable((int)2960);
        }
        Font old = this.f_96547_;
        this.f_96547_ = font;
        this.m_96597_(matrices, lines, (int)x, (int)y);
        this.f_96547_ = old;
        if (stencilEnabled) {
            GL11.glEnable((int)2960);
        }
    }

    private GuiComponent getTopLevelParent() {
        GuiComponent component = this;
        while (component.parent != null) {
            component = component.parent;
        }
        return component;
    }

    protected void drawTooltip(List<Component> lines, Font font) {
        GuiComponent topLevel = this.getTopLevelParent();
        topLevel.hoveringTextInfo.lines = lines;
        topLevel.hoveringTextInfo.x = this.getMouseX();
        topLevel.hoveringTextInfo.y = this.getMouseY();
        topLevel.hoveringTextInfo.font = font;
        topLevel.hoveringTextInfo.shouldDraw = true;
    }

    public void closeChild() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    protected void onChildClosed(GuiComponent child) {
    }

    protected void drawCentered(PoseStack matrices, Component text, int y, int color, boolean dropShadow) {
        int length = this.f_96547_.m_92852_((FormattedText)text);
        if (dropShadow) {
            this.f_96547_.m_92763_(matrices, text, (float)(this.f_96543_ - length) / 2.0f, (float)y, color);
        } else {
            this.f_96547_.m_92889_(matrices, text, (float)(this.f_96543_ - length) / 2.0f, (float)y, color);
        }
    }

    protected double getMouseX() {
        return Minecraft.m_91087_().f_91067_.m_91589_() * (double)this.f_96543_ / (double)Minecraft.m_91087_().m_91268_().m_85443_();
    }

    protected double getMouseY() {
        return Minecraft.m_91087_().f_91067_.m_91594_() * (double)this.f_96544_ / (double)Minecraft.m_91087_().m_91268_().m_85444_();
    }

    private static class HoveringTextInfo {
        List<Component> lines;
        double x;
        double y;
        Font font;
        boolean shouldDraw = false;

        private HoveringTextInfo() {
        }
    }

    @FunctionalInterface
    static interface UiCall {
        public boolean call(GuiComponent var1);
    }
}

